/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.commands;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.skinsrestorer.api.SkinVariant;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.property.GenericProperty;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.bungee.SkinsRestorer;
import net.skinsrestorer.bungee.utils.WrapperBungee;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandAlias;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandCompletion;
import net.skinsrestorer.shadow.aikar.commands.annotation.CommandPermission;
import net.skinsrestorer.shadow.aikar.commands.annotation.Description;
import net.skinsrestorer.shadow.aikar.commands.annotation.HelpCommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Optional;
import net.skinsrestorer.shadow.aikar.commands.annotation.Single;
import net.skinsrestorer.shadow.aikar.commands.annotation.Subcommand;
import net.skinsrestorer.shadow.aikar.commands.annotation.Syntax;
import net.skinsrestorer.shadow.aikar.commands.bungee.contexts.OnlinePlayer;
import net.skinsrestorer.shared.commands.ISRCommand;

@CommandAlias(value="sr|skinsrestorer")
@CommandPermission(value="%sr")
public class SrCommand
extends BaseCommand
implements ISRCommand {
    private final SkinsRestorer plugin;

    @HelpCommand
    @Syntax(value="%helpHelpCommand")
    public void onHelp(CommandSender sender, CommandHelp help) {
        this.onHelp(WrapperBungee.wrapCommandSender(sender), help);
    }

    @Subcommand(value="reload")
    @CommandPermission(value="%srReload")
    @Description(value="%helpSrReload")
    public void onReload(CommandSender sender) {
        this.onReload(WrapperBungee.wrapCommandSender(sender));
    }

    @Subcommand(value="status")
    @CommandPermission(value="%srStatus")
    @Description(value="%helpSrStatus")
    public void onStatus(CommandSender sender) {
        this.onStatus(WrapperBungee.wrapCommandSender(sender));
    }

    @Subcommand(value="drop|remove")
    @CommandPermission(value="%srDrop")
    @CommandCompletion(value="PLAYER|SKIN @players @players @players")
    @Description(value="%helpSrDrop")
    @Syntax(value=" <player|skin> <target> [target2]")
    public void onDrop(CommandSender sender, ISRCommand.PlayerOrSkin playerOrSkin, String target) {
        this.onDrop(WrapperBungee.wrapCommandSender(sender), playerOrSkin, target);
    }

    @Subcommand(value="props")
    @CommandPermission(value="%srProps")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrProps")
    @Syntax(value=" <target>")
    public void onProps(CommandSender sender, @Single OnlinePlayer target) {
        this.onProps(WrapperBungee.wrapCommandSender(sender), WrapperBungee.wrapPlayer(target.getPlayer()));
    }

    @Subcommand(value="applyskin")
    @CommandPermission(value="%srApplySkin")
    @CommandCompletion(value="@players")
    @Description(value="%helpSrApplySkin")
    @Syntax(value=" <target>")
    public void onApplySkin(CommandSender sender, @Single OnlinePlayer target) {
        this.onApplySkin(WrapperBungee.wrapCommandSender(sender), WrapperBungee.wrapPlayer(target.getPlayer()));
    }

    @Subcommand(value="createcustom")
    @CommandPermission(value="%srCreateCustom")
    @CommandCompletion(value="@skinName @skinUrl")
    @Description(value="%helpSrCreateCustom")
    @Syntax(value=" <skinName> <skinUrl> [classic/slim]")
    public void onCreateCustom(CommandSender sender, String skinName, String skinUrl, @Optional SkinVariant skinVariant) {
        this.onCreateCustom(WrapperBungee.wrapCommandSender(sender), skinName, skinUrl, skinVariant);
    }

    @Subcommand(value="setskinall")
    @CommandCompletion(value="@Skin")
    @Description(value="Set the skin to evey player")
    @Syntax(value=" <Skin / Url> [classic/slim]")
    public void onSetSkinAll(CommandSender sender, String skin, @Optional SkinVariant skinVariant) {
        this.onSetSkinAll(WrapperBungee.wrapCommandSender(sender), skin, skinVariant);
    }

    @Subcommand(value="purgeolddata")
    @Description(value="Purge old skin data from over x days ago")
    @Syntax(value=" <targetdaysold>")
    public void onPurgeOldData(CommandSender sender, int days) {
        this.onPurgeOldData(WrapperBungee.wrapCommandSender(sender), days);
    }

    @Override
    public String getPlatformVersion() {
        return this.plugin.getProxy().getVersion();
    }

    @Override
    public String getProxyMode() {
        return "Bungee-Plugin";
    }

    @Override
    public List<IProperty> getPropertiesOfPlayer(ISRPlayer player) {
        List<IProperty> props = this.plugin.getSkinApplierBungee().getProperties(player.getWrapper().get(ProxiedPlayer.class));
        if (props == null) {
            return Collections.emptyList();
        }
        return props.stream().map(property -> new GenericProperty(property.getName(), property.getValue(), property.getSignature())).collect(Collectors.toList());
    }

    public SrCommand(SkinsRestorer plugin) {
        this.plugin = plugin;
    }

    @Override
    public SkinsRestorer getPlugin() {
        return this.plugin;
    }
}

